import { StyleSheet, Dimensions } from "react-native";
import dpr from "../../Utilities/CustomStyleAttribute/dpr";
import { OnboardDP } from "./OnboardDP";

const { width, height } = Dimensions.get("window");

const { titleFontSize, textFontSize, textBottom, titleContainerBottom } =
    OnboardDP();

export const Onboard1Style = StyleSheet.create({
    container: {
        backgroundColor: "#fff",
        width: width,
    },
    illustration1: {
        position: "absolute",
        top: dpr(45),
        right: 0,
    },
    illustration2: {
        position: "absolute",
        top: dpr(45),
        left: 0,
    },
    illustration3: {
        alignSelf: "center",
        marginTop: height > 720 ? dpr(60) : dpr(50),
    },

    title: {
        fontSize: titleFontSize,
        fontFamily: "DMSans_700Bold",
    },
    title2: {
        fontSize: titleFontSize,
        fontFamily: "DMSans_700Bold",
        textAlign: "right",
    },
    title3: {
        fontSize: titleFontSize,
        fontFamily: "DMSans_700Bold",
        textAlign: "center",
        width: width,
    },
    textContainer: {
        marginTop: dpr(10),
    },
    textTitleContainer: {
        position: "absolute",
        left: dpr(20),
        right: dpr(20),
        bottom: textBottom,
    },
    textTitleContainer2: {
        position: "absolute",
        bottom: textBottom,
    },
    text: {
        fontFamily: "Roboto_500Medium",
        fontSize: textFontSize,
        color: "#898989",
    },
    text2: {
        fontFamily: "Roboto_500Medium",
        fontSize: textFontSize,
        color: "#898989",
        textAlign: "right",
    },
    text3: {
        fontFamily: "Roboto_500Medium",
        fontSize: textFontSize,
        color: "#898989",
        textAlign: "center",
        width: width,
    },
    move: {
        flexDirection: "row",
        justifyContent: "space-between",
        alignItems: "center",
        backgroundColor: "#fff",
        paddingHorizontal: dpr(20),
        paddingBottom: dpr(16),
        width: dpr("wf"),
    },
    skip: {
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(22),
        color: "#898989",
    },
});
